/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.preferences;

import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.buildpath.core.IBuildPathEntry;
import com.aptana.ui.preferences.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuildPathPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private IProject project;
    private CheckboxTableViewer tableViewer;
    private Button upButton;
    private Button downButton;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ProjectBuildPathPropertyPage.this.handleButtonPressed((Button)e.widget);
        }
    };
    private List<IBuildPathEntry> selectedEntries;

    protected Control createContents(Composite parent) {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        Set<IBuildPathEntry> entries = this.getBuildPathEntries(this.project);
        this.selectedEntries = new ArrayList<IBuildPathEntry>(this.getSelectedBuildPathEntries(this.project));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.setDescription(MessageFormat.format(Messages.ProjectBuildPathPropertyPage_TableDescription, this.project.getName()));
        Label description = this.createDescriptionLabel(composite);
        description.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).create());
        tableComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)2176);
        final Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectBuildPathPropertyPage.this.handleTableSelection();
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem item = table.getItem(new Point(e.x, e.y));
                if (item != null) {
                    table.select(table.indexOf(item));
                }
            }
        });
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(Messages.ProjectBuildPathPropertyPage_LibraryColumnLabel);
        column1.setWidth(165);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(Messages.ProjectBuildPathPropertyPage_PathColumnLabel);
        column2.setWidth(350);
        Composite buttonArea = new Composite(tableComposite, 0);
        buttonArea.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).create());
        buttonArea.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 4).create());
        this.upButton = this.createButton(buttonArea, Messages.ProjectBuildPathPropertyPage_up, false);
        this.downButton = this.createButton(buttonArea, Messages.ProjectBuildPathPropertyPage_down, false);
        this.tableViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.tableViewer.setLabelProvider(this.getLabelProvider());
        this.tableViewer.setInput(entries);
        this.tableViewer.setCheckedElements(this.selectedEntries.toArray());
        this.tableViewer.setComparator((ViewerComparator)new CheckPriorityComparator());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectBuildPathPropertyPage.this.tableViewer.refresh();
            }
        });
        return composite;
    }

    private Button createButton(Composite parent, String text, boolean enabled) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.addSelectionListener(this.buttonListener);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        button.setEnabled(enabled);
        return button;
    }

    private void handleButtonPressed(Button button) {
        if (button == this.upButton) {
            this.moveSelectedItem(true);
        } else if (button == this.downButton) {
            this.moveSelectedItem(false);
        }
        this.handleTableSelection();
        this.tableViewer.getTable().setFocus();
    }

    private void moveSelectedItem(boolean up) {
        Table table = this.tableViewer.getTable();
        int selectionIndex = table.getSelectionIndex();
        int newIndex = selectionIndex + (up ? -1 : 1);
        TableItem item = table.getItem(selectionIndex);
        Object data = item.getData();
        item.dispose();
        int selectedEntriesItemIndex = this.selectedEntries.indexOf(data);
        if (selectedEntriesItemIndex > -1) {
            if (up && selectedEntriesItemIndex > 0) {
                IBuildPathEntry toMove = this.selectedEntries.remove(selectedEntriesItemIndex);
                this.selectedEntries.add(selectedEntriesItemIndex - 1, toMove);
            } else if (!up && selectedEntriesItemIndex < this.selectedEntries.size() - 1) {
                IBuildPathEntry toMove = this.selectedEntries.remove(selectedEntriesItemIndex);
                this.selectedEntries.add(selectedEntriesItemIndex + 1, toMove);
            }
        }
        this.tableViewer.insert(data, newIndex);
        this.tableViewer.setChecked(data, selectedEntriesItemIndex > -1);
        table.setSelection(newIndex);
    }

    private void handleTableSelection() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Table table = this.tableViewer.getTable();
            if (structuredSelection.size() == 1 && table.getItemCount() > 1) {
                int selectionIndex = table.getSelectionIndex();
                TableItem item = table.getItem(selectionIndex);
                IBuildPathEntry data = (IBuildPathEntry)item.getData();
                if (item.getChecked()) {
                    this.upButton.setEnabled(selectionIndex != 0);
                    this.downButton.setEnabled(selectionIndex < table.getItemCount() - 1 && selectionIndex < this.tableViewer.getCheckedElements().length - 1);
                    if (!this.selectedEntries.contains(data)) {
                        this.selectedEntries.add(data);
                        this.tableViewer.refresh();
                    }
                } else {
                    if (this.selectedEntries.contains(data)) {
                        this.selectedEntries.remove(data);
                        this.tableViewer.refresh();
                    }
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(false);
                }
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        }
    }

    private Set<IBuildPathEntry> getBuildPathEntries(IProject project) {
        return BuildPathManager.getInstance().getBuildPaths();
    }

    private Set<IBuildPathEntry> getSelectedBuildPathEntries(IProject project) {
        return BuildPathManager.getInstance().getBuildPaths(project);
    }

    private IStructuredContentProvider getContentProvider() {
        return new BaseWorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof Set) {
                    return ((Set)element).toArray();
                }
                return super.getChildren(element);
            }
        };
    }

    private IBaseLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof BuildPathEntry) {
                    BuildPathEntry entry = (BuildPathEntry)element;
                    switch (columnIndex) {
                        case 0: {
                            return entry.getDisplayName();
                        }
                        case 1: {
                            String result = entry.getPath().toString();
                            if (result != null && result.startsWith("file:")) {
                                File f = new File(entry.getPath());
                                return f.getAbsolutePath();
                            }
                            return result;
                        }
                    }
                }
                return null;
            }
        };
    }

    public boolean performOk() {
        Object[] items = this.tableViewer.getCheckedElements();
        ArrayList<IBuildPathEntry> entries = new ArrayList<IBuildPathEntry>();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof IBuildPathEntry) {
                entries.add((IBuildPathEntry)item);
            }
            ++n2;
        }
        BuildPathManager manager = BuildPathManager.getInstance();
        Set currentEntries = manager.getBuildPaths(this.project);
        LinkedHashSet newEntries = new LinkedHashSet(entries);
        if (!Arrays.equals(currentEntries.toArray(new IBuildPathEntry[currentEntries.size()]), newEntries.toArray(new IBuildPathEntry[newEntries.size()]))) {
            manager.setBuildPaths(this.project, entries);
        }
        return true;
    }

    private class CheckPriorityComparator
    extends ViewerComparator {
        private CheckPriorityComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int e1Index = ProjectBuildPathPropertyPage.this.selectedEntries.indexOf(e1);
            int e2Index = ProjectBuildPathPropertyPage.this.selectedEntries.indexOf(e2);
            if (e1Index == -1 && e2Index == -1) {
                return super.compare(viewer, e1, e2);
            }
            if (e1Index == -1) {
                return 1;
            }
            if (e2Index == -1) {
                return -1;
            }
            return e1Index - e2Index;
        }
    }
}

